import pyxel
from random import randint
from joueur import Joueur
from envahisseur import Envahisseur

class Game:

    def __init__(self):
        self.envahisseurs = [] # tableau des envahisseurs

        pyxel.init(315, 200, title="Envahisseurs !") # fenêtre de jeu

        # Instanciation du joueur ( position initiale milieu/bas de l'écran, taille 15 x 5 )
        self.joueur = Joueur(pyxel.width//2-5, pyxel.height-10)

        # instanciation des envahisseurs ( 3 rangées de 12, de taille 20 x 5 initialement en haut de l'écran)
        for i in range(12):
            self.envahisseurs.append(Envahisseur(25*i+10, 10))
            self.envahisseurs.append(Envahisseur(25*i+10, 20))
            self.envahisseurs.append(Envahisseur(25*i+10, 30))

        pyxel.run(self.update, self.draw) # lancement du jeu

    def update(self):

        ## Gestion appui sur les touches du clavier -> déplacement du joueur/tir des rockets
        if pyxel.btn(pyxel.KEY_A): # appui sur 'A' -> déplacement vers la gauche
            self.joueur.deplacer('gauche')
        elif pyxel.btn (pyxel.KEY_P): # appui sur 'P' -> déplacement vers la droite
            self.joueur.deplacer('droite')
        elif pyxel.btnp(pyxel.KEY_SPACE): # appui sur 'SPACE' -> tir d'une roquette
            self.joueur.tirer()

        """
        ## Pour une gestion du joueur avec la souris, commenter le bloc de code précédent, et décommenter celui ci-après
        if pyxel.mouse_x < self.joueur.x: # souris vers la gauche -> déplacement vers la gauche
            self.joueur.deplacer('gauche')
        elif pyxel.mouse_x > self.joueur.x+7 : # souris vers la droite -> déplacement vers la droite
            self.joueur.deplacer('droite')
        elif pyxel.btn(pyxel.MOUSE_BUTTON_LEFT): # clic gauche -> tir d'une roquette
            self.joueur.tirer()
        """


        ## Déplacement des rockets tirées par le joueur
        for rocket in self.joueur.rockets : # parcours du tableau des rockets déja tirées par le joueur
            rocket.deplacer() # déplacement de la roquette
            if not rocket.en_vol(): # si la roquette a atteint le haut de l'écran
                self.joueur.rockets.remove(rocket) # on la supprime du tableau des roquettes
            else:
                for envahisseur in self.envahisseurs: # parcours du tableau des envahisseurs encore en jeu
                    if rocket.toucher(envahisseur) : # la rocket touche-t-elle l'envahisseur ( destruction mutuelle ) ?
                        self.envahisseurs.remove(envahisseur) # si oui, on retire l'envahisseurs du tableau des envahisseurs
                        self.joueur.rockets.remove(rocket) # et on retire la roquette du tableau des roquettes

        ## Déplacement des envahisseurs, et largage aléatoire d'une bombe par chacun d'eux
        for envahisseur in self.envahisseurs : # parcours du tableau des envahisseurs
            envahisseur.deplacer() # déplacement de l'envahisseur
            if randint(1, 500) < 3: # larguage d'une bombe avec une probabilité de 3/500
                envahisseur.larguer()# largage d'une bombe à partir de la position de l'envahisseur ( un peu en dessous...)

            # Mouvement des bombes déja larguées par chaque envahisseur
            for bombe in envahisseur.bombes : # pour chaque bombe déja larguée par l'envahisseur
                bombe.deplacer() # déplacement de la bombe
                if not bombe.en_vol(): # si la bombe a aatteint le bas de l'écran
                    envahisseur.bombes.remove(bombe) # on la supprime du tableau des bombes
                else:
                    if bombe.toucher(self.joueur) : # la bombe touche-t-elle le joueur ?
                        pyxel.quit() # si oui, on ferme la fenêtre ( ou on affiche GAME OVER )


    def draw(self):
        # Effacement de l'écran
        pyxel.cls(0)


        # Affichage du joueur
        self.joueur.afficher()

        # Affichage des rockets tirés par le joueur
        for rocket in self.joueur.rockets : # parcours du tableau des rockets déja tirées par le joueur
            rocket.afficher() # affichage de la roquette

        # Affichage des envahisseurs et des bombes larguées
        for envahisseur in self.envahisseurs : # parcours du tableau des envahisseurs
            envahisseur.afficher() # affichage de l'envahisseur
            for bombe in envahisseur.bombes: # parcours du tableau des bombes larguées par chaque envahisseur
                bombe.afficher()


# Lancement du jeu ( = instanciation d'un objet de type 'Game" )
Game()

